/*
  extsiemensmot.c

  Dispatcher of external motion functions for the Vigilant Technologies
  ISA-ENCDAC board.

  Modification history:

  24-Mar-2002  P.C. created from STG sources.
  */

#include "extintf.h"            /* these decls */
#include "siemens.h"                /* decls for stg implementation */

/* ident tag */
#ifndef __GNUC__
#ifndef __attribute__
#define __attribute__(x)
#endif
#endif

static char __attribute__((unused))  ident[] = "$Id: extsiemensmot.c,v 1.0 2002/04/15 21:02:40 paul_c Exp $";

/* Uncomment any of the following declarations to inhibit
   the use of home switches or index pulses when homing, or to
   ignore limit switches if you don't have them. */

/* Uncomment NO_HOME_SWITCH if you want homing sequence to
   ignore the home switch, and only use the index pulse for homing.
   This has the effect of making the home switches always appear tripped. */
/* #define NO_HOME_SWITCH */

/* Uncomment NO_INDEX_PULSE if you want homing sequence to
   ignore the index pulse, and only use the home switch for homing.
   This has the effect of making the index pulse always appear present. */
/* #define NO_INDEX_PULSE */

/* Uncomment NO_LIMIT_SWITCH if you don't have limit switches.
   This has the effect of making the positive and negative travel
   limit switches never appear tripped. */
/* #define NO_LIMIT_SWITCH */

int extMotInit(const char * stuff)
{
  return siemensMotInit(stuff);
}

int extMotQuit(void)
{
  return siemensMotQuit();
}

int extDacNum(void)
{
  return siemensDacNum();
}

int extDacWrite(int dac, double volts)
{
  return siemensDacWrite(dac, volts);
}

int extDacWriteAll(int max, double * volts)
{
  return siemensDacWriteAll(max, volts);
}

int extEncoderSetIndexModel(unsigned int model)
{
  return siemensEncoderSetIndexModel(model);
}

int extEncoderNum(void)
{
  return siemensEncoderNum();
}

int extEncoderRead(int encoder, double * counts)
{
  return siemensEncoderRead(encoder, counts);
}

int extEncoderReadAll(int max, double * counts)
{
  return siemensEncoderReadAll(max, counts);
}

int extEncoderResetIndex(int encoder)
{
  return siemensEncoderResetIndex(encoder);
}

int extEncoderReadLatch(int encoder, int * flag)
{
#ifdef NO_INDEX_PULSE
  *flag = 1;
  return 0;
#else
  return siemensEncoderReadLatch(encoder, flag);
#endif
}

int extEncoderReadLevel(int encoder, int * flag)
{
  return siemensEncoderReadLevel(encoder, flag);
}

int extMaxLimitSwitchRead(int axis, int * flag)
{
#ifdef NO_LIMIT_SWITCH
  *flag = 0;
  return 0;
#else
  return siemensMaxLimitSwitchRead(axis, flag);
#endif
}

int extMinLimitSwitchRead(int axis, int * flag)
{
#ifdef NO_LIMIT_SWITCH
  *flag = 0;
  return 0;
#else
  return siemensMinLimitSwitchRead(axis, flag);
#endif
}

int extHomeSwitchRead(int axis, int * flag)
{
#ifdef NO_HOME_SWITCH
  *flag = 1;
  return 0;
#else
  return siemensHomeSwitchRead(axis, flag);
#endif
}

int extAmpEnable(int axis, int enable)
{
  return siemensAmpEnable(axis, enable);
}

int extAmpFault(int axis, int * fault)
{
  return siemensAmpFault(axis, fault);
}

int extDioInit(const char * stuff)
{
  return siemensDioInit(stuff);
}

int extDioQuit(void)
{
  return siemensDioQuit();
}

int extDioMaxInputs(void)
{
  return siemensDioMaxInputs();
}

int extDioMaxOutputs(void)
{
  return siemensDioMaxOutputs();
}

int extDioRead(int index, int *value)
{
  return siemensDioRead(index, value);
}

int extDioWrite(int index, int value)
{
  return siemensDioWrite(index, value);
}

int extDioCheck(int index, int *value)
{
  return siemensDioCheck(index, value);
}

int extDioByteRead(int index, unsigned char *byte)
{
  return siemensDioByteRead(index, byte);
}

int extDioShortRead(int index, unsigned short *sh)
{
  return siemensDioShortRead(index, sh);
}

int extDioWordRead(int index, unsigned int *word)
{
  return siemensDioWordRead(index, word);
}

int extDioByteWrite(int index, unsigned char byte)
{
  return siemensDioByteWrite(index, byte);
}

int extDioShortWrite(int index, unsigned short sh)
{
  return siemensDioShortWrite(index, sh);
}

int extDioWordWrite(int index, unsigned int word)
{
  return siemensDioWordWrite(index, word);
}

int extDioByteCheck(int index, unsigned char *byte)
{
  return siemensDioByteCheck(index, byte);
}

int extDioShortCheck(int index, unsigned short *sh)
{
  return siemensDioShortCheck(index, sh);
}

int extDioWordCheck(int index, unsigned int *word)
{
  return siemensDioWordCheck(index, word);
}
/* No Analogue IO available with the vyi cards */

int extAioInit(const char * stuff)
{
  return 0;
}

int extAioQuit(void)
{
  return 0;
}

int extAioMaxInputs(void)
{
  return 0;
}

int extAioMaxOutputs(void)
{
  return 0;
}

int extAioStart(int index)
{
  return 0;
}

void extAioWait(void)
{
  return;
}

int extAioRead(int index, double *volts)
{
  return 0;
}

int extAioWrite(int index, double volts)
{
  return 0;
}

int extAioCheck(int index, double *volts)
{
  return 0;
}
