#ifndef SIEMENS_H
#define SIEMENS_H

/*
  siemens.h

  Declarations for Vigilant Technologies ISA-ENCDAC card
  
  Modification history:

  24 March 2002 P.C. Created from newstg.h and SIEMENS's isatest.cpp sources.
*/

/* ident tag */
#ifndef __GNUC__
#ifndef __attribute__
#define __attribute__(x)
#endif
#endif


static char __attribute__((unused)) siemens_h[] = "$Id: siemens.h,v 1.0 2002/04/20 23:34:05 paul_c Exp $";

// =========Register Offsets============
#define   ENCODER(x)       readw(STG_BASE_ADDRESS+(x*2))
#define   ENC_COUNT0       readw(STG_BASE_ADDRESS+0x0)
#define   ENC_COUNT1       readw(STG_BASE_ADDRESS+0x2)
#define   ENC_COUNT2       readw(STG_BASE_ADDRESS+0x4)
#define   ENC_COUNT3       readw(STG_BASE_ADDRESS+0x6)
#define   ENC_COUNT4       readw(STG_BASE_ADDRESS+0x8)
#define   ENC_COUNT5       readw(STG_BASE_ADDRESS+0xa)
#define   ENC_COUNT6       readw(STG_BASE_ADDRESS+0xc)
#define   ENC_COUNT7       readw(STG_BASE_ADDRESS+0xe)
#define   ENC_RESET        writew(0,STG_BASE_ADDRESS+0x10)
#define   ENC_STAT03       readw(STG_BASE_ADDRESS+0x12)
#define   ENC_STAT47       readw(STG_BASE_ADDRESS+0x14)
#define   ENC_MASK03(x)    writew(x,STG_BASE_ADDRESS+0x12)
#define   ENC_MASK47(x)    writew(x,STG_BASE_ADDRESS+0x14)
#define   INT_STATUS       readw(STG_BASE_ADDRESS+0xe0)
#define   INT_DIGCFG(x)    writew(x,STG_BASE_ADDRESS+0x16)
#define   DIG_RD_BK0       readw(STG_BASE_ADDRESS+0x18)
#define   DIG_RD_BK1       readw(STG_BASE_ADDRESS+0x1a)
#define   DIG_RD_BK2       readw(STG_BASE_ADDRESS+0x1c)
#define   DIG_RD_BK3       readw(STG_BASE_ADDRESS+0x1e)
#define   DIG_WR_BK0(x)    writew(x,STG_BASE_ADDRESS+0x18)
#define   DIG_WR_BK1(x)    writew(x,STG_BASE_ADDRESS+0x1a)
#define   DIG_WR_BK2(x)    writew(x,STG_BASE_ADDRESS+0x1c)
#define   DIG_WR_BK3(x)    writew(x,STG_BASE_ADDRESS+0x1e)
#define   DAC(x,y)         writew(x,STG_BASE_ADDRESS+0x20+(y*2))
#define   DAC_CHAN0(x)     writew(x,STG_BASE_ADDRESS+0x60)
#define   DAC_CHAN1(x)     writew(x,STG_BASE_ADDRESS+0x80)
#define   DAC_CHAN2(x)     writew(x,STG_BASE_ADDRESS+0xa0)
#define   TMRD_CNTR0       readb(STG_BASE_ADDRESS+0x30)
#define   TMRD_CNTR1       readb(STG_BASE_ADDRESS+0x32)
#define   TMRD_CNTR2       readb(STG_BASE_ADDRESS+0x34)
#define   TMWR_CNTR0(x)    writeb(STG_BASE_ADDRESS+0x30)
#define   TMWR_CNTR1(x)    writeb(STG_BASE_ADDRESS+0x32)
#define   TMWR_CNTR2(x)    writeb(STG_BASE_ADDRESS+0x34)
#define   TIM_CNCTL(x)     writeb(STG_BASE_ADDRESS+0x36)
#define   DAC_ENABLE       writeb(0x5a,STG_BASE_ADDRESS+0x38)
#define   DAC_DISARM       writeb(0xa5,STG_BASE_ADDRESS+0x38)
#define   DAC_SETIND       readb(STG_BASE_ADDRESS+0x3a)
#define   DAC_SETSIM       writeb(0,STG_BASE_ADDRESS+0x3a)
#define   DAC_UPDATE       writeb(0,STG_BASE_ADDRESS+0x3c)
//#define   LOGIC_CFG        writeb(0x01,STG_BASE_ADDRESS+0xc0)


// =========Interrupt definitions=======
#define   IRQ_10_VECTOR  0x72
#define   IRQ_11_VECTOR  0x73
#define   IRQ_12_VECTOR  0x74
#define   IRQ_15_VECTOR  0x77
#define   P8259_A_0      0x20
#define   P8259_A_1      0x21
#define   P8259_B_0      0xA0
#define   P8259_B_1      0xA1
#define   END_OF_INT     0x20  //Nonspecific EOI command


#include "emcmotcfg.h"		// EMCMOT_MAX_AXIS

/*
  Base address defaults to 0x330
   The use of STG_BASE_ADDRESS is retained in order to maintain compatability
   with Servo To Go run scripts etc.
  */
#define DEFAULT_STG_BASE_ADDRESS 0x0d0000
extern unsigned short STG_BASE_ADDRESS;
// extern int FIND_STG_BASE_ADDRESS;

#define DEFAULT_SIEMENS_IRQ 5
extern int SIEMENS_IRQ;

/* The mask for setting up the direction of the digital IO
   Consult the ISA-EncoderDAC manual for the format.
*/
#define DIO_CFG_MASK 0x0010

/* The switch and Amp pins are arranged in 8 bit groups - Makes
   life sooo easy for returning the pin status.
   Index range     Group function
    0 - 7           Amp Enable (output)
    8 - 15          Amp Fault (input)
   16 - 23          + Limit Switches (input)
   24 - 31          - Limit Switches (input)
   32 - 39          Home Switches (input)
   40 - 47          Spare Inputs
   48 - 55          Spare Inputs
   56 - 64          Spare Inputs
*/
#define AMP_FAULT_BASE_INDEX 8
#define MAX_LIMIT_BASE_INDEX 16
#define MIN_LIMIT_BASE_INDEX 24
#define HOME_BASE_INDEX 32
/*
Very few machines will use six axes, let alone all eight - Unused pins can be
used for general inputs. It is not recommended that the spare Amp outputs are
used by any other process - A race condition will result, producing unpredictable
results. */

/* decls for external interface */

extern int siemensMotInit(const char * stuff);
extern int siemensMotQuit(void);

extern int siemensDacNum(void);
extern int siemensDacWrite(int dac, double volts);
extern int siemensDacWriteAll(int max, double * volts);

extern int siemensEncoderSetIndexModel(unsigned int model);
extern int siemensEncoderNum(void);
extern int siemensEncoderRead(int encoder, double * counts);
extern int siemensEncoderReadAll(int max, double * counts);
extern int siemensEncoderResetIndex(int encoder);
extern int siemensEncoderReadLatch(int encoder, int * flag);
extern int siemensEncoderReadLevel(int encoder, int * flag);

extern int siemensMaxLimitSwitchRead(int axis, int * flag);
extern int siemensMinLimitSwitchRead(int axis, int * flag);

extern int siemensHomeSwitchRead(int axis, int * flag);

extern int siemensAmpEnable(int axis, int enable);
extern int siemensAmpFault(int axis, int * fault);

extern int siemensDioInit(const char * stuff);
extern int siemensDioQuit(void);

extern int siemensDioMaxInputs(void);
extern int siemensDioMaxOutputs(void);
extern int siemensDioRead(int index, int *value);
extern int siemensDioWrite(int index, int value);
extern int siemensDioCheck(int index, int *value);
extern int siemensDioByteRead(int index, unsigned char *byte);
extern int siemensDioShortRead(int index, unsigned short *sh);
extern int siemensDioWordRead(int index, unsigned int *word);
extern int siemensDioByteWrite(int index, unsigned char byte);
extern int siemensDioShortWrite(int index, unsigned short sh);
extern int siemensDioWordWrite(int index, unsigned int word);
extern int siemensDioByteCheck(int index, unsigned char *byte);
extern int siemensDioShortCheck(int index, unsigned short *sh);
extern int siemensDioWordCheck(int index, unsigned int *word);

/* internal functions */
void RawDacOut(int dac, double volts);

typedef union
{
  signed long int	Long;
  signed short int	Word[1];
} LongWord;


#endif /* SIEMENS_H */
